// @ts-check
const {
    HEAD0,
    HEAD1
} = require('./MessageCreator');
const _ = require('underscore');
const CONSTANTS = require('../../constants');

class MessageReader {
    read(data, device) {
        if (data[0] == HEAD0 && data[1] == HEAD1) {
            var debugOutstringErr = true;
            var nextOffset = 7;
            var packetSize = this.getPacketSize(data[2], data[3]);
            var outstring = '' + packetSize;
            var moreMessages = true;
            var messages = [];
            var i = 0;
            while (moreMessages) {
                var valuesize = this.getValSize(data[2 + nextOffset], data[3 + nextOffset], data[4 + nextOffset]);
                var idx = this.getIdx(data[9 + nextOffset], data[10 + nextOffset]);
                var sidx = this.getSidx(data[11 + nextOffset], data[12 + nextOffset]);
                var value;
                var dataob;
                var name = '';
                var levelData = false;
                var AmpStateData = false;
                var UIData = false;
                if (valuesize == 4) {
                    if (idx == 1) {
                        if (sidx == 4 || sidx == 13) {
                            value = this.getU32(data[13 + nextOffset], data[14 + nextOffset], data[15 + nextOffset], data[16 + nextOffset]);
                        } else {
                            value = this.getVal(data[13 + nextOffset], data[14 + nextOffset], data[15 + nextOffset], data[16 + nextOffset]);
                        }
                    } else if (idx == 6) {
                        if (sidx == 41 || sidx == 46) {
                            value = this.getU32(data[13 + nextOffset], data[14 + nextOffset], data[15 + nextOffset], data[16 + nextOffset]);
                        } else {
                            value = this.getVal(data[13 + nextOffset], data[14 + nextOffset], data[15 + nextOffset], data[16 + nextOffset]);
                        }
                    } else if (idx == 48) {
                        if (sidx == 103) {
                            value = this.getU32(data[13 + nextOffset], data[14 + nextOffset], data[15 + nextOffset], data[16 + nextOffset]);
                        } else {
                            value = this.getVal(data[13 + nextOffset], data[14 + nextOffset], data[15 + nextOffset], data[16 + nextOffset]);
                        }
                    } else {
                        value = this.getVal(data[13 + nextOffset], data[14 + nextOffset], data[15 + nextOffset], data[16 + nextOffset]);
                    }
                } else {
                    if (idx == 48) {
                        if (sidx == 100) {
                            levelData = true;
                            var k;
                            for (k = 0; k < 8; k++) {
                                var l = this.getU32(data[13 + nextOffset + (k * 4)], data[14 + nextOffset + (k * 4)], data[15 + nextOffset + (k * 4)], data[16 + nextOffset + (k * 4)]) / 10.0;
                                var str = 'InputLevel';
                                var ch = k;
                                if (k > 3) {
                                    ch = k - 4;
                                    str = 'OutputLevel';
                                }
                                var datalevel = {
                                    id: str,
                                    value: convertLevelToMeters(l, ch, str, device),
                                    channelId: ch,
                                    ignore: false,
                                    db: l,
                                    dbRMS: convertLevelToMeters(getRmsLevel(l, ch, str, device), ch, str, device)
                                }
                                messages.push(datalevel);
                            }
                        } else if (sidx == 103) {
                            value = this.getU32(data[13 + nextOffset], data[14 + nextOffset], data[15 + nextOffset], data[16 + nextOffset]);
                        } else if (sidx == 104) {
                            levelData = true;
                            var k1;
                            for (k1 = 0; k1 < 8; k1++) {
                                var l1 = this.convertLevel(data[13 + nextOffset + (k1 * 4)], data[14 + nextOffset + (k1 * 4)], data[15 + nextOffset + (k1 * 4)], data[16 + nextOffset + (k1 * 4)]);
                                var str1 = 'GainReduktionRMS';
                                var ch1 = k1;
                                if (k1 > 3) {
                                    ch1 = k1 - 4;
                                    str1 = 'GainReduktionPeak';
                                }
                                messages.push({ id: str1, value: convertLimiterToMeters(l1, ch1, str1), channelId: ch1, ignore: false, db: l1 });
                            }
                        }
                    } else if (idx == 9) {
                        var k3;
                        var charcode;
                        for (k3 = 0; k3 < valuesize; k3++) {
                            charcode = data[13 + nextOffset + k3];
                            name = name + String.fromCharCode(charcode);
                        }
                    } else if (idx == 13) {
                        AmpStateData = true;
                        const dataContent = data.slice(13 + nextOffset, (1024 + 13 + nextOffset));
                        if (sidx == 10) {
                            messages.push({ id: "AmpStateMeta", value: dataContent, channelId: ch1, ignore: false, packetId: (sidx - 10) });
                        } else {
                            messages.push({ id: "AmpStatePacket", value: dataContent, channelId: ch1, ignore: false, packetId: (sidx - 11) });
                        }
                    } else if (idx == 21) {
                        if (sidx == 4) {
                            UIData = true;
                            var k4; // leveldata
                            for (k4 = 0; k4 < 8; k4++) {
                                var ui = this.convertFloat32(data[13 + nextOffset + (k4 * 4)], data[14 + nextOffset + (k4 * 4)], data[15 + nextOffset + (k4 * 4)], data[16 + nextOffset + (k4 * 4)]) / 10.0;
                                var strui = 'Voltage';
                                var chui = 0;
                                if (k4 == 1) {
                                    strui = 'Current';
                                } else if (k4 == 2) {
                                    chui = 1;
                                } else if (k4 == 3) {
                                    strui = 'Current';
                                    chui = 1;
                                } else if (k4 == 4) {
                                    chui = 2;
                                } else if (k4 == 5) {
                                    strui = 'Current';
                                    chui = 2;
                                } else if (k4 == 6) {
                                    chui = 3;
                                } else if (k4 == 7) {
                                    strui = 'Current';
                                    chui = 3;
                                }
                                console.log({ id: strui, value: ui, channelId: chui });
                                messages.push({ id: strui, value: ui, channelId: chui, ignore: false });
                            }
                        } else if (sidx == 100 || sidx == 102 || sidx == 104 || sidx == 106) {
                            // SpeakerParam
                            dataob = {
                                onoff: this.getU32(data[13 + nextOffset], data[14 + nextOffset], data[15 + nextOffset], data[16 + nextOffset]),
                                dam: Math.log10(Math.round(this.convertFloat32(data[17 + nextOffset], data[18 + nextOffset], data[19 + nextOffset], data[20 + nextOffset]) * 10000) / 10000) * 20,
                                freq: this.getU32(data[21 + nextOffset], data[22 + nextOffset], data[23 + nextOffset], data[24 + nextOffset]),
                                minR: this.convertFloat32(data[25 + nextOffset], data[26 + nextOffset], data[27 + nextOffset], data[28 + nextOffset]),
                                maxR: this.convertFloat32(data[29 + nextOffset], data[30 + nextOffset], data[31 + nextOffset], data[32 + nextOffset])
                            };
                        }
                    }
                }
                var header = (data[1 + nextOffset] & 0x7);
                if (debugOutstringErr && idx > 0) {
                    if (header == 0x4) {
                        if (idx != 10 && sidx != 9) console.log(outstring + ' haeder read error ' + header.toString(2) + " " + idx + "." + sidx + "." + value);
                    } else if (header == 0x5) {
                        if (idx != 10 && sidx != 9) console.log(outstring + ' haeder write error ' + header.toString(2) + " " + idx + "." + sidx + "." + value);
                    }
                }
                nextOffset = nextOffset + 12 + valuesize;
                i++;
                if (!levelData && !AmpStateData && !UIData) {
                    var node = this.getCommandTarget(idx, sidx, value, dataob, name, header, device && device.type);
                    if (node) {
                        if (_.isArray(node)) {
                            _.each(node, element => {
                                messages.push(element);
                            });
                        } else {
                            messages.push(node);
                        }
                    }
                }
                if (data[3 + nextOffset] == HEAD1 && data[4 + nextOffset] == HEAD0) moreMessages = false;
                if (data[5 + nextOffset] == HEAD0 && data[6 + nextOffset] == HEAD1) {
                    moreMessages = true;
                    nextOffset = nextOffset + 12;
                    packetSize = this.getPacketSize(data[7], data[8]);
                }
                if (i == 2000) moreMessages = false;
            }
            return messages;
        }
    }

    getI32(firstByte, secondByte, thirdByte, fourthByte) {
        var I32 = (fourthByte << 24 | thirdByte << 16 | secondByte << 8 | firstByte);
        if (I32 > 32768) I32 = I32 - 65536;
        return I32;
    }

    getU32(firstByte, secondByte, thirdByte, fourthByte) {
        return (fourthByte << 24 | thirdByte << 16 | secondByte << 8 | firstByte);
    }

    getUS(firstByte, secondByte) {
        return (secondByte << 8 | firstByte);
    }

    convertLevel(firstByte, secondByte, thirdByte, fourthByte) {
        var fl = new Float32Array(new Uint8Array([firstByte, secondByte, thirdByte, fourthByte]).buffer)[0];
        var db = 20 * Math.log10(fl);
        var rt = Math.round((db) * 10) / 10.0;
        return rt;
    }

    convertFloat32(firstByte, secondByte, thirdByte, fourthByte) {
        return new Float32Array(new Uint8Array([firstByte, secondByte, thirdByte, fourthByte]).buffer)[0];
    }

    intBitsToFloat(i) {
        var int8 = new Int8Array(4);
        var int32 = new Int32Array(int8.buffer, 0, 1);
        var float32 = new Float32Array(int8.buffer, 0, 1);
        int32[0] = i;
        return float32[0];
    }

    getPacketSize(first, second) {
        return this.getUS(first, second);
    }

    getIdx(first, second) {
        return this.getUS(first, second);
    }

    getSidx(first, second) {
        return this.getUS(first, second);
    }

    getVal(first, second, third, fourth) {
        return this.getI32(first, second, third, fourth);
    }

    getValSize(first, second, third) {
        return this.getU32(first, second, third, 0);
    }

    getCommandTarget(idx, sidx, value, data, name, header, Amptype) {
        if (idx == 0 && sidx == 1) {
            return { id: "Heartbeat", value: 0, channelId: -1, ignore: false }
        } else if (idx == 48) {
            if (sidx == 102) {
                return [{ id: "PeakLimit", value: (value & 0x1) == 1, channelId: 0, ignore: false },
                 { id: "PeakLimit", value: (value & 0x2) == 2, channelId: 1, ignore: false },
                 { id: "PeakLimit", value: (value & 0x4) == 4, channelId: 2, ignore: false },
                 { id: "PeakLimit", value: (value & 0x8) == 8, channelId: 3, ignore: false },
                 { id: "RMSLimit", value: (value & 0x10) == 16, channelId: 0, ignore: false },
                 { id: "RMSLimit", value: (value & 0x20) == 32, channelId: 1, ignore: false },
                 { id: "RMSLimit", value: (value & 0x40) == 64, channelId: 2, ignore: false },
                 { id: "RMSLimit", value: (value & 0x80) == 128, channelId: 3, ignore: false }]
            } else if (sidx == 103) {
                return [{ id: "AesReceiver1Lock", value: (value & 0x10000) == 0x10000 ? 1 : 0, channelId: -1, ignore: false },
                 { id: "AesReceiver2Lock", value: (value & 0x20000) == 0x20000 ? 1 : 0, channelId: -1, ignore: false },
                 { id: "Fallback", value: (value & 0x40000) == 0x40000 ? 1 : 0, channelId: -1, ignore: false }]
            }
        } else if (idx == 10) {
            if (sidx == 9) {
                return { id: "OkMessage", value: value, channelId: -1, ignore: false }
            }
        } else if (idx == 22) {
            if (sidx > 13) {
                return { id: "Mute", value: value == 1, channelId: (sidx - 14), ignore: false }
            }
        } else if (idx == 40) {
            if (sidx == 100) {
                return { id: "Fir40Uploaded", value: true, channelId: -1, ignore: false }
            }
        } else if (idx == 44) {
            if (sidx == 100) {
                return { id: "Fir44Uploaded", value: true, channelId: -1, ignore: false }
            }
        } else if (idx == 1) {
            if (sidx == 3) {
                return { id: "FW_Seriennummer", value: name, channelId: -1, ignore: false }
            } else if (sidx == 4) {
                return { id: "FW_OEMSerial", value: value, channelId: -1, ignore: false }
            } else if (sidx == 12) {
                return { id: "FW_VERSION", value: (value & 0xFF), channelId: -1, ignore: false }
            } else if (sidx == 13) {
                return { id: "FW_DATUM", value: value, channelId: -1, ignore: false }
            }
        } else if (idx == 2) {
            if (sidx == 4) {
                return { id: "FirmwareName", value: value, channelId: -1, ignore: false }
            } else if (sidx == 5) {
                return { id: "FirmwareStored", value: value, channelId: -1, ignore: false }
            } else if (sidx == 6) {
                return { id: "FirmwareDate", value: value, channelId: -1, ignore: false }
            } else if (sidx == 7) {
                return { id: "FirmwareVersion", value: value, channelId: -1, ignore: false }
            } else if (sidx == 8) {
                return { id: "FirmwareRevision", value: value, channelId: -1, ignore: false }
            } else if (sidx == 9) {
                return { id: "FirmwareErased", value: value, channelId: -1, ignore: false }
            } else if (sidx >= 10) {
                return { id: "FirmwarePage" + idx + "." + sidx, value: value, channelId: -1, ignore: false }
            }
        } else if (idx == 3) {
            return { id: "FirmwarePage" + idx + "." + sidx, value: value, channelId: -1, ignore: false }
        } else if (idx == 4) {
            return { id: "FirmwarePage" + idx + "." + sidx, value: value, channelId: -1, ignore: false }
        } else if (idx == 5) {
            if (sidx == 11) {
                return { id: "ActualPreset", value: value, channelId: -1, ignore: false }
            } else if (sidx == 100 || sidx == 101 || sidx == 102 || sidx == 103) {
                return { id: "ActualSpeaker", value: value + 9, channelId: (sidx - 100), ignore: false }
            }
        } else if (idx == 6) {
            if (sidx == 5) {
                return { id: "DisplayLock", value: (value == 1), channelId: -1, ignore: false }
            } else if (sidx == 10) {
                return { id: "InputSource", value: value, channelId: -1, ignore: false }
            } else if (sidx == 12) {
                return { id: "FallbackMode", value: value, channelId: -1, ignore: false }
            } else if (sidx == 13) {
                return { id: "EnableFallback", value: (value == 1), channelId: -1, ignore: false }
            } else if (sidx == 19) {
                return { id: "FallbackSense", value: value, channelId: -1, ignore: false }
            } else if (sidx == 14) {
                return { id: "ActiveInputSource", value: value, channelId: -1, ignore: false }
            } else if (sidx == 15) {
                return { id: "AesReceiver1", value: value, channelId: -1, ignore: false }
            } else if (sidx == 16) {
                return { id: "AesReceiver2", value: value, channelId: -1, ignore: false }
            } else if (sidx == 20) {
                return { id: "HardwareAmpStatus", value: value, channelId: -1, ignore: false }
            } else if (sidx == 40) {
                return { id: "AesReceiver1Lock", value: value, channelId: -1, ignore: false }
            } else if (sidx == 41) {
                return { id: "AesReceiver1SampleRate", value: (value / 1000.0).toFixed(1), channelId: -1, ignore: false }
            } else if (sidx == 42) {
                // aesReceiver 1 sample AES-Modus: Bit0: 1=Pro 0=Consumer, Bit1: 1=Copyprotected
            } else if (sidx == 43) {
                // aesReceiver 1 errorcode 0=OK
            } else if (sidx == 45) {
                return { id: "AesReceiver2Lock", value: value, channelId: -1, ignore: false }
            } else if (sidx == 46) {
                return { id: "AesReceiver2SampleRate", value: (value / 1000.0).toFixed(1), channelId: -1, ignore: false }
            } else if (sidx == 47) {
                // aesReceiver 2 sample AES-Modus: Bit0: 1=Pro 0=Consumer, Bit1: 1=Copyprotected
            } else if (sidx == 48) {
                // aesReceiver 2 errorcode 0=OK
            } else if (sidx == 50) {
                return { id: "AuxState", value: value, channelId: -1, ignore: false }
            } else if (sidx == 51) {
                return { id: "InputAuxMode", value: value, channelId: -1, ignore: false }
            } else if (sidx == 52) {
                return { id: "InputAlarmAudioMode", value: value, channelId: -1, ignore: false }
            } else if (sidx == 53) {
                return { id: "AuxAudioArlamState", value: value, channelId: -1, ignore: false }
            } else if (sidx == 54) {
                return { id: "AuxSetAmpOk", value: value, channelId: -1, ignore: false }
            } else if (sidx == 60) {
                return [ { id: "SensorEnabled0", value: (value & 0x1) == 0x1, channelId: 0, ignore: false },
                 { id: "SensorEnabled1", value: (value & 0x2) == 0x2, channelId: 1, ignore: false },
                 { id: "SensorEnabled2", value: (value & 0x4) == 0x4, channelId: 2, ignore: false },
                 { id: "SensorEnabled3", value: (value & 0x8) == 0x8, channelId: 3, ignore: false } ]
            } else if (sidx == 61) {
                return [ { id: "SensorDetected", value: (value & 0x1) == 0x1, channelId: 0, ignore: false },
                 { id: "SensorDetected", value: (value & 0x2) == 0x2, channelId: 1, ignore: false },
                 { id: "SensorDetected", value: (value & 0x4) == 0x4, channelId: 2, ignore: false },
                 { id: "SensorDetected", value: (value & 0x8) == 0x8, channelId: 3, ignore: false } ]
            } else if (sidx == 62) {
                return [ { id: "SensorActive", value: (value & 0x1) == 0x1, channelId: 0, ignore: false },
                 { id: "SensorActive", value: (value & 0x2) == 0x2, channelId: 1, ignore: false },
                 { id: "SensorActive", value: (value & 0x4) == 0x4, channelId: 2, ignore: false },
                 { id: "SensorActive", value: (value & 0x8) == 0x8, channelId: 3, ignore: false } ]
            }
        } else if (idx == 7) {
            if (sidx == 60) {
                return { id: "SysUnitLock", value: (value == 1), channelId: -1, ignore: false }
            } else if (sidx == 61) {
                return { id: "SysUnitPwd", value: value, channelId: -1, ignore: false }
            } else if (sidx == 62) {
                return { id: "SysPcLock", value: (value == 1), channelId: -1, ignore: false }
            } else if (sidx == 63) {
                return { id: "SysPcPwd", value: value, channelId: -1, ignore: false }
            }
        } else if (idx == 8) {
            if (sidx == 10) {
                if (Amptype) {
                    if (Amptype == "LINUS5C" || Amptype == "LINUS10C") {
                        return { id: "HardwareAmpStatus", value: value, channelId: -1, ignore: false }
                    }
                }
            } else if (sidx == 11) {
                // protect error 1 oder 2 hypex docu, sram fehler kann ich nicht abfragen EWManual_Coda_V071.pages
                // console.log("MessageReader Gets errorcode on ch1: ", value);
                return { id: "AmpModuleState", value: name, channelID: 0, ignore: false };
            } else if (sidx == 12) {
                // console.log("MessageReader Gets errorcode on ch2: ", value);
                return { id: "AmpModuleState", value: name, channelID: 1, ignore: false };
            } else if (sidx == 13) {
                // console.log("MessageReader Gets errorcode on ch3: ", value);
                return { id: "AmpModuleState", value: name, channelID: 2, ignore: false };
            } else if (sidx == 14) {
                // console.log("MessageReader Gets errorcode on ch4: ", value);
                return { id: "AmpModuleState", value: name, channelID: 3, ignore: false };
            }
        } else if (idx == 9) {
            if (sidx == 2) {
                return { id: "FirmwareOEM_id", value: name, channelId: -1, ignore: false }
            } else if (sidx == 3) {
                return { id: "UserBank1", value: name, channelId: -1, ignore: false }
            } else if (sidx == 4) {
                return { id: "UserBank2", value: name, channelId: -1, ignore: false }
            } else if (sidx == 6) {
                return { id: "SpeakerLibName", value: name, channelId: -1, ignore: false }
            } else if (sidx == 7) {
                if (name) {
                    var str = "";
                    str = name;
                    console.log("check name of LINUS10C " + str);
                    if (name == "DMOD2SX-CODA-LIC") {
                        name = "LINUS10C";
                    }
                    if (str.includes("LINUS5C")) {
                        name = "LINUS5C";
                    }
                    if (str.includes("LINUS10C")) {
                        name = "LINUS10C";
                    }
                }
                return { id: "DeviceName", value: name, channelId: -1, ignore: false }
            } else if (sidx == 8) {
                return { id: "UserName", value: name, channelId: -1, ignore: false }
            } else if (sidx == 9) {
                return { id: "PresetLibName", value: name, channelId: -1, ignore: false }
            } else {
                if (sidx < CONSTANTS.SLOT_SPEAKER_OFFSET) {
                    return { id: "PresetName" + (sidx - 9), index: sidx - 9, value: getSpeakerSlotNrUsedInPreset(name, (sidx - 9)), channelId: -1, ignore: false }
                } else {
                    return { id: "SpeakerName" + sidx, index: sidx, value: getSpeakerNrFromName(name), channelId: -1, ignore: false }
                }
            }
        } else if (idx == 13) {
            if (sidx == 1) {
                return { id: "AmpStateMaxSize", value: value, channelId: -1, ignore: false }
            }
            if (sidx == 2) {
                return { id: "AmpStateSize", value: value, channelId: -1, ignore: false }
            }
            if (sidx == 3) {
                return { id: "AmpStatePacketSize", value: value, channelId: -1, ignore: false }
            }
        } else if (idx == 18) {
            if (sidx == 1) {
                return { id: "AutoTest", value: value, channelId: -1, ignore: false }
            }
        } else if (idx == 20) {
            if (sidx == 10) {
                return { id: "Gain", value: value / 10.0, channelId: 0, ignore: false }
            } else if (sidx == 14) {
                return { id: "Gain", value: value / 10.0, channelId: 1, ignore: false }
            } else if (sidx == 18) {
                return { id: "Gain", value: value / 10.0, channelId: 2, ignore: false }
            } else if (sidx == 22) {
                return { id: "Gain", value: value / 10.0, channelId: 3, ignore: false }
            } else {
                return { id: "Gain", channelId: (sidx - 10) / 4, error: "ERROR!" }
            }
        } else if (idx == 21) {
            if (sidx == 1) {
                return { id: "AutoSendUI", value: value, channelId: -1, ignore: false }
            } else if (sidx == 4) {
                // F32, Word1...8, 1) U1 in V, 2) I1 in A, 3) U2 in V, 4) I2 in A, 5) U3 in V, 6) I3 in A, 7) U4 in V, 8) I4 in A
                return { id: "UIValues", value: value, channelId: -1, ignore: false }
            } else if (sidx == 13) {
                // console.log("SiggenMux: " + value);
                return { id: "SiggenMux", value: value, ignore: false }
            } else if (sidx == 14) {
                return { id: "SpeakerTestState", value: value, ignore: false }
            } else if (sidx == 101 || sidx == 103 || sidx == 105 || sidx == 107) {
                return { id: "SpeakerResistance", value: Math.floor(value * 10.0) / 100, channelId: ((sidx - 101) / 2), ignore: false }
            } else if (sidx == 100 || sidx == 102 || sidx == 104 || sidx == 106) {
                return { id: "SpeakerTestparam", value: data, channelId: ((sidx - 100) / 2), ignore: false }
            }
        } else if (idx == 23) {
            if (sidx < 14) {
                return { id: "ActualRoute", value: [((value & 0x1) == 1), ((value & 0x2) == 2), ((value & 0x4) == 4), ((value & 0x8) == 8)], channelId: sidx - 10, ignore: false }
            } else if (sidx < 24) {
                return { id: "AnalogRoute", value: [((value & 0x1) == 1), ((value & 0x2) == 2), ((value & 0x4) == 4), ((value & 0x8) == 8)], channelId: sidx - 20, ignore: false }
            } else if (sidx < 34) {
                return { id: "DigitalRoute", value: [((value & 0x1) == 1), ((value & 0x2) == 2), ((value & 0x4) == 4), ((value & 0x8) == 8)], channelId: sidx - 30, ignore: false }
            } else if (sidx < 44) {
                return { id: "DanteRoute", value: [((value & 0x1) == 1), ((value & 0x2) == 2), ((value & 0x4) == 4), ((value & 0x8) == 8)], channelId: sidx - 40, ignore: false }
            } else {
                return { id: "Route", channelId: (sidx - 50), error: "ERROR!" }
            }
        } else if (idx == 24) {
            if (sidx == 10 || sidx == 11 || sidx == 12 || sidx == 13) {
                if (Amptype) {
                    if (Amptype == "LINUS5C" || Amptype == "LINUS10C") {
                        return { id: "Delay", value: (value / 96.0 * 2), channelId: (sidx - 10), ignore: false }
                    } else {
                        return { id: "Delay", value: (value / 96.0), channelId: (sidx - 10), ignore: false }
                    }
                }
            } else {
                return { id: "Delay", channelId: sidx, error: "ERROR! " + idx + "." + sidx }
            }
        } else if (idx == 34) {
            var invertphase;
            if (sidx == 10) {
                invertphase = (value & 0xFF) == 2;
                return { id: "Phase", value: invertphase, channelId: 0, ignore: false }
            } else if (sidx == 11) {
                invertphase = ((value & 0xff00) >> 8) == 2;
                return { id: "Phase", value: invertphase, channelId: 1, ignore: false }
            } else if (sidx == 12) {
                invertphase = ((value & 0xff0000) >> 16) == 2;
                return { id: "Phase", value: invertphase, channelId: 2, ignore: false }
            } else if (sidx == 13) {
                invertphase = ((value & 0xff000000) >> 24) == 2;
                return { id: "Phase", value: invertphase, channelId: 3, ignore: false }
            } else {
                return { id: "Phase", channelId: (sidx - 10), error: "ERROR!" }
            }
        } else if (idx == 50 || idx == 51 || idx == 52 || idx == 53) {
            if (sidx == 12) {
                return { id: "Array", value: convertedArrayEqValueFromEQOneGain(value), channelId: (idx - 50), ignore: false }
            } else if (sidx == 20) {
                return { id: "Sizing", value: convertedSizingEqValueFromEQThreeGain(value) / 10.0, channelId: (idx - 50), ignore: false }
            } else if (sidx == 24) {
                return { id: "HfShelf", value: value / 10.0, channelId: (idx - 50), ignore: false }
            } else if (sidx == 28) {
                return { id: "Human", value: value / 10.0, channelId: (idx - 50), ignore: false }
            } else if (sidx == 32) {
                return { id: "LowBoost", value: value / 10.0, channelId: (idx - 50), ignore: false }
            } else if (sidx == 36) {
                return { id: "SubSonic", value: value / 10.0, channelId: (idx - 50), ignore: false }
            } else if (sidx == 40) {
                return { id: "Distance", value: value, channelId: (idx - 50), ignore: false }
            } else if (sidx >= 54) {
                var eqnr = Math.floor((sidx - 54) / 4.0);
                var eqparam = sidx - 54 - (eqnr * 4);
                if (eqparam == 0) {
                    if (value == 11) value = 2;
                    if (value == 10) value = 3;
                    return { id: "EqType", value: value, channelId: (idx - 50), ignore: false, eqnr }
                } else if (eqparam == 1) {
                    return { id: "EqFreq", value: value, channelId: (idx - 50), ignore: false, eqnr }
                } else if (eqparam == 2) {
                    return { id: "EqGain", value: value / 10.0, channelId: (idx - 50), ignore: false, eqnr }
                } else if (eqparam == 3) {
                    return { id: "EqQual", value: value / 1000.0, channelId: (idx - 50), ignore: false, eqnr }
                }
            }
        } else if (idx == 80 || idx == 81 || idx == 82 || idx == 83) {
            let outeqnr = Math.floor((sidx - 10) / 4.0);
            let outeqparam = sidx - 10 - (outeqnr * 4);
            if (outeqparam == 0) {
                return { id: "SpeakerEqTypeEnabled", value, channelId: (idx - 80), ignore: false, eqnr: outeqnr }
            }
        } else if (idx == 60 || idx == 61 || idx == 62 || idx == 63) {
            let outeqnr = Math.floor((sidx - 10) / 4.0);
            let outeqparam = sidx - 10 - (outeqnr * 4);
            if (outeqparam == 0) {
                return { id: "SpeakerXoverEnabled", value, channelId: (idx - 60), ignore: false, eqnr: outeqnr }
            }
        }
    }
}

function convertedArrayEqValueFromEQOneGain(value) {
    if (value == 120) {
        return 1;
    } else if (value == 90) {
        return 2;
    } else if (value == 60) {
        return 3;
    } else if (value == 30) {
        return 4;
    } else if (value == 20) {
        return 5;
    } else if (value == 10) {
        return 6;
    } else if (value == 6) {
        return 7;
    } else if (value == 0) {
        return 8;
    } else if (value == -3) {
        return 9;
    } else if (value == -5) {
        return 10;
    } else if (value == -10) {
        return 11;
    } else if (value == -17) {
        return 12;
    } else if (value == -25) {
        return 13;
    } else if (value == -35) {
        return 14;
    } else if (value == -45) {
        return 15;
    } else if (value == -60) {
        return 16;
    } else if (value == -70) {
        return 17;
    } else if (value == -85) {
        return 18;
    } else if (value == -95) {
        return 19;
    } else if (value == -105) {
        return 20;
    } else {
        return 0;
    }
}

function convertedSizingEqValueFromEQThreeGain(val) {
    if (val == -60) {
        return 5; // lsval = -60; lsq = 707; lsf = 450;  // 10,6 dB Q
    } else if (val == -54) {
        return 6; // lsval = -54; lsq = 707; lsf = 435;
    } else if (val == -47) {
        return 7; // lsval = -47; lsq = 707; lsf = 420;
    } else if (val == -40) {
        return 8; // lsval = -40; lsq = 707; lsf = 410; // 12,6 dB Q
    } else if (val == -22) {
        return 9; // lsval = -22; lsq = 707; lsf = 405;
    } else if (val == 0) {
        return 10; // lsval = 0; lsq = 707; lsf = 400;
    } else if (val == 7) {
        return 11; // lsval = 7; lsq = 707; lsf = 1250;
    } else if (val == 15) {
        return 12; // lsval = 15; lsq = 707; lsf = 1280;
    } else if (val == 24) {
        return 13; // lsval = 24; lsq = 707; lsf = 1300;
    } else if (val == 35) {
        return 14; // lsval = 35; lsq = 707; lsf = 1350;
    } else if (val == 40) {
        return 15; // lsval = 40; lsq = 707; lsf = 1400;
    } else if (val == 45) {
        return 16; // lsval = 45; lsq = 707; lsf = 1500; // 12,6 dB
    } else if (val == 49) {
        return 17; // lsval = 49; lsq = 707; lsf = 1600;
    } else if (val == 53) {
        return 18; // lsval = 53; lsq = 707; lsf = 1700;
    } else if (val == 57) {
        return 19; // lsval = 57; lsq = 707; lsf = 1900;
    } else if (val == 60) {
        return 20; // lsval = 60; lsq = 707; lsf = 2000;
    } // 1900Hz 11,2 dB Q
    return 0
}

function convertLevelToMeters(l, ch, str, device) {
    if (l < 0 && str == 'InputLevel') l = l - 3.8;
    var out = 0.01;
    if (l >= -36) {
        out = 1.0 + (l / 36 * 0.75);
    } else if (l >= -58) {
        out = 0.25 + (((l + 36) / 22) * 0.13);
    } else if (l >= -78) {
        out = 0.12 + ((l + 58) / 20 * 0.12);
    }
    return out;
}

const rmsSampler = {}
const samplerSize = 5;

const channelTemplate = () => _.reduce(_.range(4), (result, channel) => {
    result[channel] = _.map(_.range(samplerSize), () => 0);
    return result;
}, {});

const samplerTemplate = () => ({
    InputLevel: channelTemplate(),
    OutputLevel: channelTemplate()
})

function getRmsLevel(value, channel, type, device) {
    let sampler = rmsSampler[device.id];
    if (!sampler) {
        sampler = samplerTemplate();
        rmsSampler[device.id] = sampler;
    }

    const queue = sampler[type][channel];
    queue.pop();
    queue.unshift(value);

    const sum = _.reduce(queue, (current, item) => current + (item * item), 0);
    return -1.0 * Math.sqrt(sum / (samplerSize * 1.0));
}

function convertLimiterToMeters(l, ch, str) {
    var out = 0;
    if (l < -10) {
        out = 1.0;
    } else {
        out = l / -10.0;
    }
    return out;
}

function getSpeakerNrFromName(speakerName) {
    var nr;
    nr = messageReader.getUS(speakerName.charCodeAt(speakerName.length - 2), speakerName.charCodeAt(speakerName.length - 1));
    return nr;
}

function getSpeakerSlotNrUsedInPreset(SlotName, SlotNr) {
    if (SlotNr == 21) {
        return SlotName.substring(0, 16).trim();
    } else {
        return SlotName.substring(0, 16).trim();
    }
}

const messageReader = new MessageReader();

module.exports = {
    messageReader,
    MessageReader
}